<?php
/* http://www.upupw.net */
/* webmaster@upupw.net */
$version="19.08.06SF";
date_default_timezone_set('America/New_York') && error_reporting(0);
function _GET($n) { return isset($_GET[$n]) ? $_GET[$n] : NULL; }
function _SERVER($n) { return isset($_SERVER[$n]) ? $_SERVER[$n] : '[undefine]'; }
function memory_usage() { $memory  = ( ! function_exists('memory_get_usage')) ? '0' : round(memory_get_usage()/1024/1024, 2).'MB'; return $memory;}
function micro_time_float() { $mtime = microtime(); $mtime = explode(' ', $mtime); return $mtime[1] + $mtime[0];}
function get_hash() {
  return sha1(uniqid());
}
@session_start();
$currentTime = time();
$changeTime = 86400;
$rand = '';
if(isset($_SESSION['time']) and ($currentTime - $_SESSION['time']) < $changeTime) {
  $rand = $_SESSION['rand'];
}else{
  $_SESSION['time'] = $currentTime;
  $_SESSION['rand'] = $rand = get_hash();
}
@header("content-Type: text/html; charset=utf-8");
define('YES', '<span style="color: #008000; font-weight : bold;">Enable</span>');
define('NO', '<span style="color: #e74c3c; font-weight : bold;">Disable</span>');
if ($_POST['mysqlPort']=="") {
$host="127.0.0.1";
} else {
$host="127.0.0.1:".$_POST['mysqlPort'];
}
$Info = array();
$Info['php_ini_file'] = function_exists('php_ini_loaded_file') ? php_ini_loaded_file() : '[undefine]';
$mcrypt = get_extension_funcs('mcrypt') ? YES : NO;
$xmlrpc = get_extension_funcs('xmlrpc') ? YES : NO;
$fileinfo = get_extension_funcs('fileinfo') ? YES : NO;
$ftp = get_extension_funcs('ftp') ? YES : NO;
$link = @mysqli_connect($host, $_POST['mysqlUser'], $_POST['mysqlPassword']);
$errno = mysqli_connect_errno();
$pinfo = $rand;
$up_start = micro_time_float();
if (_GET($pinfo) == 'phpinfo') {
if (function_exists('phpinfo')) phpinfo();
else echo "PHPINFO function has been disabled can not normally display details!";
exit;
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>UPUPW PHP Prober - Security Edition</title>
<meta name="keywords" content="php prober,upupw prober,security,php7 prober,phpinfo,php extend,database connection test" />
<meta name="description" content="upupw php security edition of the probe is compatible with the latest php7, the need to successfully test the connection to the local database only after showing the phpinfo dynamic link page and site path, more secure php probes." />
<meta name="author" content="UPUPW" />
<meta name="reply-to" content="webmaster@upupw.net" />
<meta name="copyright" content="UPUPW Team" />
<style type="text/css">
<!--
*{margin:0px;padding:0px;}
body {background-color:#FFFFFF;color:#000000;margin:0px;font-family:Helvetica,Arial,Verdana;}
input {text-align:center;width:200px;height:20px;padding:5px;}
a:link {color:green; text-decoration:none;}
a:visited {color:green;text-decoration:none;}
a:active {color:green;text-decoration:none;}
a:hover {color:#ed776b;text-decoration:none;}
table {border-collapse:collapse;margin:10px 0px;clear:both;}
.inp tr th, td {padding:2px 5px 2px 5px;vertical-align:center;text-align:center;height:30px; border:1px #FFFFFF solid;}
.head1 {background-color:#2c3e50;width:100%;font-size:36px;color:#ffffff;padding-top:10px;text-align:center;font-family:Georgia,"Times New Roman",Times,serif; font-weight:bold;}
.head2 {background-color: #1abc9c; width: 100%; font-size: 18px; height: 18px; color: #ffffff; }
.el {text-align: center; background-color: #d3e1e5; }
.er {text-align: right; background-color: #d3e1e5; }
.ec {text-align: center; background-color: #1abc9c; font-weight: bold; color: #FFFFFF; }
.fl {text-align: left; background-color: #ecf0f1; color: #505050; }
.fr {text-align:right;background-color:#eeeeee;color:#505050;}
.fc {text-align: center; background-color: #ecf0f1; color: #505050; }
.ft {text-align:center;background-color: #D9F9DE;color:#060;}
a.arrow {font-family:webdings,sans-serif;font-size:10px;}
a.arrow:hover {color:#ff0000;text-decoration:none;}
-->
</style>
</head>
<body>
<div class="head1"><a href="http://www.upupw.net/tanzhen/n127.html" style="color:#ffffff" >{ UPUPW PHP Prober }</a></div>
<div class="head2"></div>
<div style="margin:0 auto;width:1140px;overflow:hidden;">
<table width="100%" class="inp">
<tr>
<th colspan="2" class="ec" width="50%">Server Information</th>
<th colspan="2" class="ec" width="50%">PHP Extended State</th>
</tr>
<tr>
<td class="er" width="15%">Server Domain</td>
<td class="fl" width="35%"><?=_SERVER('SERVER_NAME')?></td>
<td class="er" width="20%">MySQLi Client</td>
<td class="fc" width="30%"><?=get_extension_funcs('mysqli') ? YES : NO ?></td>
</tr>
<tr>
<td class="er">Server Port</td>
<td class="fl">
<?php if(isset($_POST['act'])) {?>
<?=($link)?_SERVER('SERVER_ADDR').':'._SERVER('SERVER_PORT'):"<span style='color:red'>Does not show: Database test error!</span>"?>
<?php }
else echo "<a href='#data'><span style='color:green'>Database test success will show</span></a>";
?>
</td>
<td class="er">cURL</td>
<td class="fc"><?=get_extension_funcs('curl') ? YES : NO ?></td>
</tr>
<tr>
<td class="er">Web Server</td>
<td class="fl"><?=stripos(_SERVER('SERVER_SOFTWARE'), 'PHP')?_SERVER('SERVER_SOFTWARE'):_SERVER('SERVER_SOFTWARE')?></td>
<td class="er">GD library</td>
<td class="fc"><?=get_extension_funcs('gd') ? YES : NO ?></td>
</tr>
<tr>
<td class="er">	PHP Version</td>
<td class="fl"><?=PHP_SAPI .' PHP/'.PHP_VERSION?></td>
<td class="er">EXIF</td>
<td class="fc"><?=get_extension_funcs('exif') ? YES : NO ?></td>
</tr>
<tr>
<td class="er">PHP INI</td>
<td class="fl" style="word-break:break-all;word-wrap:break-word"><?php if(isset($_POST['act'])) {?>
<?=($link)?htmlentities($Info['php_ini_file']):"<span style='color:red'>Does not show: Database test error!</span>"?>
<?php }
else echo "<a href='#data'><span style='color:green'>Database test success will show</span></a>";
?>
</td>
<td class="er">OpenSSL</td>
<td class="fc"><?=get_extension_funcs('openssl') ? YES : NO ?></td>
</tr>
<tr>
<td class="er">Site Path</td>
<td class="fl" style="word-break:break-all;word-wrap:break-word"><?php if(isset($_POST['act'])) {?>
<?=($link)?htmlentities(_SERVER('DOCUMENT_ROOT')):"<span style='color:red'>Does not show: Database test error!</span>"?>
<?php }
else echo "<a href='#data'><span style='color:green'>Database test success will show</span></a>";
?>
</td>
<?php
if(version_compare(PHP_VERSION,'7.0.0', '<')){
	echo "<td class='er'>Mcrypt</td><td class='fc'>".$mcrypt."</td>";
}else{
	echo "<td class='er'>FTP</td><td class='fc'>".$ftp."</td>";
}?>
</tr>
<tr>
<td class="er">Server Time</td>
<td class="fl">
<?=gmdate('Y-m-d H:i:s', time() - 3600 * 4)?>
</td>
<?php
if(version_compare(PHP_VERSION,'5.3.0', '<')){
	echo "<td class='er'>XML-RPC</td><td class='fc'>".$xmlrpc."</td>";
}else{
	echo "<td class='er'>FileInfo</td><td class='fc'>".$fileinfo."</td>";
}?>
</tr>
<tr>
<td class="er">Management</td>
<td class="fl"><?php if(isset($_POST['act'])) {?>
<?=($link)?"<a target='_blank' href='?$pinfo=phpinfo'>PHPINFO</a>":"<span style='color:red'>Does not show: Database test error!</span>"?>
<?php }
else echo "<a href='#data'><span style='color:green'>Database test success will show</span></a>";
?>
</td>
<td class="er">SendMail</td>
<td class="fc"><?=get_extension_funcs('standard') ? YES : NO ?></td>
</tr>
</table>
<table width="100%" class="inp">
<tr>
<td colspan="4" class="ec" width="50%">PHP Zend</td>
<td colspan="4" class="ec" width="50%">PHP Cache</td>
</tr>
<tr>
<td class="el">Zend Optimizer</td>
<td class="el">Zend GuardLoader</td>
<td class="el">ionCubeLoader</td>
<td class="el">SourceGuardian</td>
<td class="el">WinCache</td>
<td class="el">Zend OPcache</td>
<td class="el">Redis</td>
<td class="el">Memcache</td>
</tr>
<tr>
<td class="fc"><?=get_extension_funcs('Zend Optimizer') ? YES.' / '.OPTIMIZER_VERSION : NO ?></td>
<td class="fc"><?=get_extension_funcs('Zend Guard Loader') ? YES : NO ?></td>
<td class="fc"><?=get_extension_funcs('ionCube Loader') ? YES : NO ?></td>
<td class="fc"><?=get_extension_funcs('SourceGuardian') ? YES : NO ?></td>
<td class="fc"><?=get_extension_funcs('WinCache') ? YES : NO ?></td>
<td class="fc"><?=get_extension_funcs('Zend OPcache') ? YES : NO ?></td>
<td class="fc"><?=phpversion('redis') ? YES : NO ?></td>
<td class="fc"><?=get_extension_funcs('memcache') ? YES : NO ?></td>
</tr>
<tr>
<td colspan="8" class="ft"><?=PHP_SAPI .' PHP/'.PHP_VERSION?> is not entirely including the above components, the external expansion of different PHP different!</td>
</tr>
</table>
<table width="100%" class="inp">
<tr>
<td colspan="6" class="ec" width="100%">PHP Performance Parameters</td>
</tr>
<tr>
<td class="el">Memory Limit</td>
<td class="el">Upload Max Filesize</td>
<td class="el">Post Max Size</td>
<td class="el">Max Execution Time</td>
<td class="el">Input TimeOut</td>
<td class="el">Socket TimeOut</td>
</tr>
<tr>
<td class="fc"><?=ini_get('memory_limit')?></td>
<td class="fc"><?=ini_get('upload_max_filesize')?></td>
<td class="fc"><?=ini_get('post_max_size')?></td>
<td class="fc"><?=ini_get('max_execution_time').'s'?></td>
<td class="fc"><?=ini_get('max_input_time').'s'?></td>
<td class="fc"><?=ini_get('default_socket_timeout').'s'?></td>
</tr>
</table>
<table width="100%" class="inp">
<tr>
<th class="ec">PHP Enabled Module List</th>
</tr>
<tr>
<td class="fl" style="text-align:center;">
<?php
$able=get_loaded_extensions();
foreach ($able as $key=>$value) {
if ($key!=0 && $key%13==0) {
echo '<br />';
}
echo "$value&nbsp;&nbsp;&nbsp;&nbsp;";
}
?>
</td>
</tr>
</table>
<form method="post" action="<?=htmlentities($_SERVER['PHP_SELF'])?>">
<table width="100%" id="data" class="inp">
<tr>
<th colspan="4" class="ec">Database Connection Test</th>
</tr>
<tr>
<td colspan="4" class="ft">Please modify the default password for the database</td>
</tr>
<tr>
<td width="25%" class="er">Host</td>
<td width="25%" class="fl"><input type="text" name="mysqlHost" value="127.0.0.1" disabled="true"/></td>
<td width="25%" class="er">Port</td>
<td width="25%" class="fl"><input type="text" name="mysqlPort" value="" /></td>
</tr>
<tr>
<td class="er">Username</td>
<td class="fl"><input type="text" name="mysqlUser" value="" /></td>
<td class="er">Password</td>
<td class="fl"><input type="password" name="mysqlPassword" /></td>
</tr>
<tr>
<td colspan="4" align="center" style="padding-top:15px"><input type="submit" value=" Submit " name="act" style="height:30px;" /></td>
</tr>
</table>
</form>
<?php if(isset($_POST['act'])) {?>
<table width="100%" class="inp">
<tr>
<th colspan="4" class="ec">Database Test Results</th>
</tr>
<?php
if ($link) $str1 = '<span style="color: #008000; font-weight: bold;">Connect Successfully </span> ('.mysqli_get_server_info($link).')';
else $str1 = '<span style="color: #ff0000; font-weight: bold;">Connection Error</span><br />'.mysqli_connect_error();
?>
<tr>
<td colspan="2" class="er" width="50%"><?=$host?></td>
<td colspan="2" class="fl" width="50%"><?=$str1?></td>
</tr>
</table>
<?php }?>
<p style="color:#33384e;font-size:14px;text-align:center; margin-bottom:2px;">
<?php $up_time = sprintf('%0.6f', micro_time_float() - $up_start);?>UPUPW Prober Version:<?php echo $version?>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Execution Time: <?php echo $up_time?>(second)&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Memory: <?php echo memory_usage();?>
</p>
<hr style="width:100%; color:#cdcdcd" noshade="noshade" size="1" />
<p style="color:#505050; font-size:14px; text-align:center;">&copy; <?php echo date("Y")?> <a href="http://www.upupw.net">UPUPW PHP Prober</a>. Site content has nothing to do with upupw.</p>
</div>
</body>
</html>
